<?php
/****************************************
 * XKLog 后台管理页
 *
 * 此文件控制输出后台管理页
 *
 * 更新：2009-06-23
 * 版本：V1.0
 ****************************************/

require('../include/loader.php');
@header("content-Type: text/html; charset=utf-8");

if( !user_is_super_admin() ){
	//SafeLogger("试图直接访问后台页面 admin_data.php 。")
	//SafeDefender()
	show_admin_message( '您尚未登录，或者登录已过期' );
	exit;
}

$action = getGP( 'action', 'G' );

switch( $action ) {
    case 'Batch':
    	batch();
    	break;
    case 'RestoreExe':
    	restore_exe();
    	break;
}

function batch() {
	global $db,$_CACHE;
	$backup_tables = array();
	$backup_tables = getGP( 'table_arr','P','array' );
	$control = getGP( 'Control','P' );
	$size = count( $backup_tables );
	if( $size == 0 ) {
		obclean();
		show_admin_message( '您没有选中任何数据表', 'admin_data.php?action=Backup' );
		exit;
	}
	$back_file_name = 'XKLog_' . date( 'ymd', PHP_TIME ) . '_' . substr( md5( PHP_TIME ), -8) . '.sql';
	$db->query('SET SQL_QUOTE_SHOW_CREATE=0');
	$bakcontent = "# XKLog Data Backup File\n# Data Version: V" . XKLOG_DATA_VERSION . "\n# Time: ".date('Y-m-d H:i', PHP_TIME)."\n# URL: http://www.xklab.cn\n#--------------------------------------\n\n";
	$bakcontent .= table_backup( $backup_tables );
	$bakcontent .= data_backup( $backup_tables );
	$back_file_path = XKLOG_ROOT . 'data/' . $back_file_name;
	file_put_contents( $back_file_path, $bakcontent );
	show_admin_message( "数据备份完成，生成备份文件 $back_file_name", 'admin_data.php?action=Backup' );
	exit;
}

function restore_exe() {
	$back_file = getGP( 'name','G' );
	data_restore( XKLOG_ROOT . 'data/' . $back_file );
	cache_load();
	show_admin_message( "数据导入完成", 'admin_data.php?action=Restore' );
	exit;
}

function table_backup( $backup_tables ) {
	global $db;
	$sql = '';
	foreach ( $backup_tables as $table ) {
		$row = $db->fetch_one_array("SHOW CREATE TABLE $table");
		$sql .= "DROP TABLE IF EXISTS $table;\n\n";
		$sql .= $row['Create Table'].";\n\n";
	}
	return $sql;
}

function data_backup( $backup_tables ) {
	global $db;
	$table_num = count($backup_tables);
	$baksql = '';
	for ( $i = 0; $i < $table_num; $i ++ ) {
		// Online 表中的数据就不用备份了
		if( $backup_tables[$i] == strtolower( PREFIX_STR . 'Online' ) ) continue;
		$baksql .= "TRUNCATE TABLE $backup_tables[$i];\n";
		$status = $db->fetch_one_array("SHOW TABLE STATUS LIKE '$backup_tables[$i]'");
		$rows = $status['Rows'];
		$query = $db->query("SELECT * FROM `" . $backup_tables[$i] . "`");
		$fields = $db->num_fields( $query );
		while ( $row = $db->fetch_array( $query,MYSQL_NUM ) ) {
			$baksql .= "INSERT INTO $backup_tables[$i] VALUES ('" . mysql_escape_string( $row[0] ) . "'";
			for ( $j = 1; $j < $fields; $j++) {
				$baksql .= " ,'" . mysql_escape_string( $row[$j] ) . "'";
			}
			$baksql .= ");\n";
		}
		$db->free_result($query);
	}
	return $baksql;
}

function data_restore( $back_file ) {
	global $db;
	$query = '';
	$baksql = file( $back_file );
	foreach ($baksql as $ikey => $val) {
		$val = trim($val);
		if (!$val || substr($val,0,1) == '#') continue;
		if ( eregi('\;$', $val) ) {
			$query .= $val;
			if ( eregi('^CREATE',$query) ) {
				$query = substr($query, 0, strrpos($query, ')')+1);
				if( $db->version() > '4.1' ){
					$query .= 'ENGINE=MyISAM DEFAULT CHARSET=utf8;';
				} else {
					$query .= 'TYPE=MyISAM;';
				}
			} elseif ( eregi('^INSERT', $query) ) {
				$query = 'REPLACE '.substr($query,6);
			}
			$db->query($query);
			$query = '';
		} else {
			$query .= $val;
		}
	}
}
?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns = "http://www.w3.org/1999/xhtml" lang = "zh-cn">
<head>
	<meta http-equiv = "Content-Type" content = "text/html; charset=UTF-8" />
	<meta http-equiv = "Content-Language" content = "UTF-8" />
	<title><?php echo $_CACHE['set'][0]['BlogName'] ?> - 后台管理</title>
	<link rel = "stylesheet" type = "text/css" href = "../Include/Style.css" />
	<script language="javascript" type="text/javascript" src="../Include/admin.js"></script>
</head>
<body id = "Admin_Body">
<div id = "Admin_Main">
<center>

	<div class = "Admin_Panel">
		<div class = "Admin_Title"> 数据管理</div>
		<div class = "Admin_Content">
			<div style="padding:5px;margin:2px;border:1px solid #96C2F1;background-color: #EFF7FF;"><a href="admin_data.php?action=Backup">数据备份</a> | <a href="admin_data.php?action=Restore">数据恢复</a> | <a href="admin_data.php?action=Check">数据修正</a></div>
<?php

switch( $action ) {
    case 'Backup':
        backup();
    	break;
    case 'Restore':
        restore();
    	break;
    case 'Check':
        check();
    	break;
	default:
		main();
}

function backup() {
	global $db,$_CACHE;
	$query = $db->query("SHOW TABLE STATUS");
	$prelen = strlen( PREFIX_STR );
	$sys_tables = $other_tables = array();
	while ( $row = $db->fetch_array($query) ) {
		$aname = substr($row['Name'],0,$prelen) == strtolower( PREFIX_STR ) ? 'sys_tables' : 'other_tables';
		${$aname}[] = array(
		'name' => $row['Name'],
		'rows' => $row['Rows'],
		'size' => $row['Data_length'] + $row['Index_length']
		);
	}
?>
			<form name="smslist" action="admin_data.php?action=Batch" method="post">
				<div style="padding:5px;margin:2px;">      
					<table class="pickme" style="table-layout: fixed;word-wrap: break-word;" width="100%" border="0" cellpadding="0" cellspacing="1" bgcolor="b5d6e6" onmouseover="changeto()"  onmouseout="changeback()">
						<thead>
							<tr align="center" height="22" bgcolor="#ffffff">
								<td width="3%"  background="../Include/bg.gif"><input type="checkbox" name="allbox" onclick="CheckAll();"><input type="checkbox" id="ckbox" style="display:none;" disabled></td>
								<td width="3%"  background="../Include/bg.gif">序号</td>
								<td width="25%" background="../Include/bg.gif">表名</td>
								<td width="40%" background="../Include/bg.gif">记录数</td>
								<td width="29%" background="../Include/bg.gif">大小</td>
							</tr>
						</thead>
						<tbody>
							<?php
							for ($i = 0; $i < count( $sys_tables ) ; $i ++) {
							?>
							<tr align="center" height="20" bgcolor="#ffffff">
								<td><input type="checkbox" id="ckbox" name="table_arr[]" value="<?php echo $sys_tables[$i]['name'] ?>" /></td>
								<td><?php echo $i+1 ?></td>
								<td style="text-align:left;padding-left:10px;"><?php echo $sys_tables[$i]['name'] ?></td>
								<td><?php echo $sys_tables[$i]['rows'] ?> 条</td>
								<td>
								<?php
								if( $sys_tables[$i]['size'] < 1024 ){
									echo $sys_tables[$i]['size'] . 'B';
								}elseif( $sys_tables[$i]['size'] < 1024*1024 ) {
									echo round( $sys_tables[$i]['size']/1024, 2 ) . 'KB';
								}else{
									echo round( $sys_tables[$i]['size']/(1024*1024), 2 ) . 'MB';
								}
								?>
								</td>
							</tr>
							<?php
							}
							?>
						<tbody>
					</table>
				</div>
				<div align="center">批量管理选项: <input type="radio" name="Control" value="备份" checked="checked"/>备份 <input type="submit" name="functionmit" class="Main_Button" value="执行操作" /></div>
			</form>
<?php
}

function restore() {
	$file_arr = array();
	$data_path = XKLOG_ROOT . 'data/';
	$handle = opendir( $data_path ); 
	while ( ( $each_file = readdir( $handle ) ) !== false ) {
		if ( $each_file != '.' && $each_file != '..' && end( explode( '.', $each_file ) ) == 'sql' ) {
			$fp = fopen( $data_path . $each_file, 'rb');
			$back_info = fread($fp, 200);
			fclose($fp);
			$back_info = explode("\n", $back_info);
			$file_arr[] = array( 'name' => $each_file, 'size' => filesize( $data_path . $each_file ), 'version' => substr( $back_info[1], 17 ), 'time' => substr( $back_info[2],8 ) );
		}
	}
	closedir( $handle ); 
?>
			<div style="padding:5px;margin:2px;">      
				<table style="table-layout: fixed;word-wrap: break-word;" width="100%" border="0" cellpadding="0" cellspacing="1" bgcolor="b5d6e6" onmouseover="changeto()"  onmouseout="changeback()">
					<thead>
						<tr align="center" height="22" bgcolor="#ffffff">
							<td width="3%"  background="../Include/bg.gif"></td>
							<td width="3%"  background="../Include/bg.gif">序号</td>
							<td width="20%" background="../Include/bg.gif">文件名</td>
							<td width="20%" background="../Include/bg.gif">数据版本</td>
							<td width="20%" background="../Include/bg.gif">备份时间</td>
							<td width="21%" background="../Include/bg.gif">文件大小</td>
							<td width="13%" background="../Include/bg.gif">管理操作</td>
						</tr>
					</thead>
					<tbody>
						<?php
						for ($i = 0; $i < count( $file_arr ) ; $i ++) {
						?>
						<tr align="center" height="20" bgcolor="#ffffff">
							<td></td>
							<td><?php echo $i+1 ?></td>
							<td style="text-align:left;padding-left:10px;"><?php echo $file_arr[$i]['name'] ?></td>
							<td><?php echo $file_arr[$i]['version'] ?></td>
							<td><?php echo $file_arr[$i]['time'] ?></td>
							<td>
							<?php
							if( $file_arr[$i]['size'] < 1024 ){
								echo $file_arr[$i]['size'] . 'B';
							}elseif( $file_arr[$i]['size'] < 1024*1024 ) {
								echo round( $file_arr[$i]['size']/1024, 2 ) . 'KB';
							}else{
								echo round( $file_arr[$i]['size']/(1024*1024), 2 ) . 'MB';
							}
							?>
							</td>
							<td><img src="../Include/edt.gif" width="16" height="16" /><span class="Control"><a href="admin_data.php?action=RestoreExe&name=<?php echo $file_arr[$i]['name'] ?>">导入</a></span></td>
						</tr>
						<?php
						}
						?>
					<tbody>
				</table>
			</div>
<?php
}

function main() {
?>
			<div style="padding:10px;">
				欢迎进行 <b>数据管理</b>，在这里您可以备份当前的数据，也可以恢复以前的数据。
			</div>
<?php
}

function check() {
?>
			<div style="padding:10px;">
				<a href="admin_set.php?action=ReBuildExe">重建系统缓存</a>
				<a href="admin_sort.php?action=DataCheckExe">重新统计分类数据</a>
				<a href="admin_article.php?action=DataCheckExe">重新统计日志的评论数</a>
			</div>
<?php
}
?>
			<div class="Main_Button"></div>
		</div>
	</div>

	<div id="Foot"><?php show_run_info() ?></div>
</center>
</div>
</body>
</html>